## App Context

You can access the whole ```App``` instance in layout functions, special methods and all callbacks. the ```App``` instance control the whole app, you can use it to do many things, e.g. register special app events, add new observe layout and find any component in the app.

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        print(appctx.get_app())
        return mui.VBox([
            mui.Typography("Hello App Context"),
            mui.Button("Click", self._on_click),
        ])

    async def _on_click(self):
        print(appctx.get_app())

```

In example above, you can get the instance of whole tutorial app (not the wrapper of ```App``` in code above).

### Features

* find component

You can find component by type via ```appctx.find_component```, this is extermely useful when you want to control a component in a decouple way.

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.Typography("Hello Find Component"),
            mui.Button("Click", self._on_click),
        ])

    async def _on_click(self):
        validator = lambda x: x.props.value == "Hello Find Component"
        comp = appctx.find_component(mui.Typography, validator)
        if comp is not None:
            await comp.send_and_wait(comp.update_event(color="aqua"))

```

```find_component``` will return when encounter first component that match the type and validator. if validator is None, it will return when encounter first component that match the type. if no component match the type and validator, it will return None.

This function is a base function for many useful functions in appctx, e.g. ```appctx.inspector.update_locals``` will use ```find_component``` to find the ```plus.ObjectInspector``` component, then send current function locals tree to inspector. ```appctx.canvas.unknown_visualization``` will use ```find_component``` to find the ```plus.SimpleCanvas``` component, then do visualization for your data.

* inspector

You can use ```appctx.inspector``` to control the ```plus.ObjectInspector``` component. ```appctx.inspector.update_locals``` will send current function locals tree to inspector.

The left part of this tutorial App is ```plus.ObjectInspector```. you can see changes when you click in following example.

```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.Typography("Hello App Context"),
            mui.Button("Click", self._on_click),
        ])

    async def _on_click(self):
        a = 5
        b = 3
        await appctx.inspector.update_locals()

```

You can also use sync version of ```appctx.inspector.update_locals_sync```, this is useful when you debug a large project.

```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

def nested_func2():
    a = 4
    b = 4
    appctx.inspector.update_locals_sync()


def nested_func():
    return nested_func2()

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.Typography("Hello App Context"),
            mui.Button("Click", self._on_click),
        ])

    async def _on_click(self):
        nested_func()

```
